#include <stdio.h>
#include <errno.h>
#include <fcntl.h>
#include "cpmio.h"
#include "cpmfio.h"

/************************************************************************
 * NAME:	cpm_init()
 *
 * DESCR:	Initialize the cpm data structure.
 *
 * ARGS:	cpmfs is filled in
 *
 * RETURNS:	
 *
 * NOTES:	
 ************************************************************************/
int
cpm_init(struct cpmfs *cpmfs, 
	 cpmdevice device, 
	 cpmreadfn readblkfn, 
	 cpmwritefn writeblkfn)
{
    cpmfs->device = device;
    cpmfs->preadsec = readblkfn;
    cpmfs->pwritesec = writeblkfn;

    cpmfs->bitmap = NULL;

    return(TRUE);
}

int
cpm_settings(struct cpmfs *cpmfs,
	     int blksiz,	/* size of the blocks		*/
	     int tracks,	/* number of tracks		*/
	     int maxdir,	/* maximum directory entries	*/
	     int seclth,	/* length of a sector		*/
	     int sectrk,	/* sectors per track		*/
	     int skew,		/* sector skew			*/
	     int restrk,	/* num of reserved tracks	*/
	     int startsec,	/* physical start sect number	*/
	     int openfiles)	/* max number of open files	*/
{
    cpmfs->blksiz = blksiz;
    cpmfs->tracks = tracks;
    cpmfs->maxdir = maxdir;
    cpmfs->seclth = seclth;
    cpmfs->sectrk = sectrk;
    cpmfs->skew = skew;
    cpmfs->restrk = restrk;
    cpmfs->startsec = startsec;

    cpmfs->use16bitptrs = ((tracks - restrk) * sectrk * seclth) / blksiz > 255;

    if ((cpmfs->dirbuf = (struct directory *) malloc(cpmfs->maxdir*32)) == NULL ) {
	return(FALSE);
    }

    cpmfs->numfiles = openfiles;
    if ((cpmfs->c_iob = (C_FILE *) malloc(sizeof(C_FILE)*openfiles)) == NULL) {
	return(FALSE);
    }

    {
	int i;
	for( i=0; i < openfiles; i++) {
	    cpmfs->c_iob[i].c_flag = 0;
	}
    }

    if (!cpm_gen_sktab(cpmfs)) {
	return(FALSE);
    }
    if (!cpm_getdir(cpmfs)) {
	return(FALSE);
    }
    if (!cpm_build_bmap(cpmfs)) {
	return(FALSE);
    }

    return(TRUE);
}


/************************************************************************
 * NAME:	cpm_cleanup()
 *
 * DESCR:	Frees any allocated structures.  This should really "flush"
 *		too.
 *
 * ARGS:	
 *
 * RETURNS:	
 *
 * NOTES:	
 ************************************************************************/
int
cpm_cleanup(struct cpmfs *cpmfs)
{
    free(cpmfs->skewtab);
    free(cpmfs->bitmap);
    free(cpmfs->dirbuf);

    return(TRUE);
}



